#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_PatientRecordReport : BaseTest 
	{
		
		private DataTable _dtPatient;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Patient", true);

				this.RefreshData = false;
			}
		}

		[Test]
		public void GetPatientRecordReportCount_Pass()
		{
			System.Guid patientGuid = (System.Guid)this._dtPatient.Rows[0][TABLES.Patient.PatientGuid];

			int count = DAL.PatientRecordReport.GetPatientRecordReportCount(patientGuid, UnitTestConfig.TestDivisionCode,true,true,true,true,true,true,true,true,true);
			Assert.IsTrue(count >= 0);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetPatientRecordReportCount_Fail()
		{
			int count = DAL.PatientRecordReport.GetPatientRecordReportCount(Guid.NewGuid(), UnitTestConfig.TestDivisionCode,false,false,false,false,false,false,false,false,false);
		}

		[Test]
		public void GetPatientRecordReport_Pass()
		{
			System.Guid patientGuid = (System.Guid)this._dtPatient.Rows[0][TABLES.Patient.PatientGuid];

			DataSet ds = DAL.PatientRecordReport.GetPatientRecordReport(patientGuid, UnitTestConfig.TestDivisionCode,true,true,true,true,true,true,true,true,true);
			Assert.AreEqual(32,ds.Tables.Count, "Tables.Count");
		}

		[Test]
		public void GetPatientRecordReport_Fail()
		{
			DataSet ds = DAL.PatientRecordReport.GetPatientRecordReport(Guid.NewGuid(), UnitTestConfig.TestDivisionCode,true,true,true,true,true,true,true,true,true);
			Assert.AreEqual(0,ds.Tables[0].Rows.Count);
		}

	}
}

#endif
